<?php
/**
 * related_artist.php - Last.fm Similar Artists API
 * 
 * This file is now LEGACY and not used by the main flow.
 * The functionality has been integrated into openai_handler.php.
 * 
 * However, this file can still be used standalone for testing
 * or as a separate endpoint if needed.
 */

header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET');
header('Access-Control-Allow-Headers: Content-Type');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

// Configuration
$LASTFM_API_KEY = 'eb57575a04a81a77b0dea173d5f87788';

// Get input
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $input = file_get_contents('php://input');
    $data = json_decode($input, true);
    $artistName = isset($data['artist_name']) ? $data['artist_name'] : '';
} else {
    // Also support GET requests
    $artistName = isset($_GET['artist']) ? $_GET['artist'] : '';
}

if (empty($artistName)) {
    http_response_code(400);
    echo json_encode(['error' => 'artist_name or artist parameter is required']);
    exit();
}

// Call Last.fm API
$similarArtists = getSimilarArtistsFromLastFm($artistName, $LASTFM_API_KEY);

if (empty($similarArtists)) {
    http_response_code(200);
    echo json_encode([
        'artists' => [],
        'seed_artist' => $artistName,
        'message' => 'No similar artists found on Last.fm'
    ]);
    exit();
}

http_response_code(200);
echo json_encode([
    'artists' => $similarArtists,
    'seed_artist' => $artistName,
    'count' => count($similarArtists),
    'source' => 'lastfm'
]);

/**
 * Get similar artists from Last.fm API
 */
function getSimilarArtistsFromLastFm($artistName, $apiKey) {
    $url = 'https://ws.audioscrobbler.com/2.0/?method=artist.getsimilar&artist=' 
           . urlencode($artistName) 
           . '&api_key=' . $apiKey 
           . '&format=json&limit=20';
    
    $ch = curl_init($url);
    curl_setopt_array($ch, [
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_TIMEOUT => 10,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_USERAGENT => 'ArtistPromptBuilder/2.0'
    ]);
    
    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    $error = curl_error($ch);
    curl_close($ch);
    
    if ($error) {
        error_log("Last.fm API cURL error: " . $error);
        return [];
    }
    
    if ($httpCode !== 200) {
        error_log("Last.fm API returned HTTP " . $httpCode);
        return [];
    }
    
    $data = json_decode($response, true);
    
    // Check for API errors
    if (isset($data['error'])) {
        error_log("Last.fm API error: " . $data['message']);
        return [];
    }
    
    if (!isset($data['similarartists']['artist']) || !is_array($data['similarartists']['artist'])) {
        return [];
    }
    
    $similarArtists = [];
    foreach ($data['similarartists']['artist'] as $artist) {
        if (isset($artist['name']) && !empty(trim($artist['name']))) {
            $artistData = ['name' => trim($artist['name'])];
            
            // Add Last.fm URL if available
            if (isset($artist['url'])) {
                $artistData['lastfm_url'] = $artist['url'];
            }
            
            // Add MusicBrainz ID if available
            if (isset($artist['mbid']) && !empty($artist['mbid'])) {
                $artistData['mbid'] = $artist['mbid'];
            }
            
            // Add match score
            if (isset($artist['match'])) {
                $artistData['match'] = floatval($artist['match']);
            }
            
            // Add image if available
            if (isset($artist['image']) && is_array($artist['image'])) {
                foreach ($artist['image'] as $img) {
                    if ($img['size'] === 'large' && !empty($img['#text'])) {
                        $artistData['image'] = $img['#text'];
                        break;
                    }
                }
            }
            
            $similarArtists[] = $artistData;
        }
    }
    
    return $similarArtists;
}

/**
 * USAGE EXAMPLES:
 * 
 * POST Request:
 * curl -X POST http://localhost:8000/related_artist.php \
 *   -H "Content-Type: application/json" \
 *   -d '{"artist_name":"Nine Inch Nails"}'
 * 
 * GET Request:
 * curl http://localhost:8000/related_artist.php?artist=Nine+Inch+Nails
 * 
 * Response:
 * {
 *   "artists": [
 *     {
 *       "name": "How to Destroy Angels",
 *       "lastfm_url": "https://www.last.fm/music/How+to+Destroy+Angels",
 *       "mbid": "143b396d-a678-43aa-8c74-628fea8e381f",
 *       "match": 1.0,
 *       "image": "https://lastfm.freetls.fastly.net/i/u/174s/..."
 *     }
 *   ],
 *   "seed_artist": "Nine Inch Nails",
 *   "count": 20,
 *   "source": "lastfm"
 * }
 */
?>