<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST');
header('Access-Control-Allow-Headers: Content-Type');

// Handle preflight requests
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

// Only accept POST requests
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['error' => 'Method not allowed']);
    exit();
}

// Get the request body
$input = file_get_contents('php://input');
$data = json_decode($input, true);

if (!isset($data['prompt']) || empty(trim($data['prompt']))) {
    http_response_code(400);
    echo json_encode(['error' => 'Prompt is required']);
    exit();
}

$prompt = trim($data['prompt']);

// Configuration
$OPENAI_API_KEY = getenv('OPENAI_API_KEY') ?: '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';
$LASTFM_API_KEY = 'eb57575a04a81a77b0dea173d5f87788';
$MIN_ARTISTS = 10;

if ($OPENAI_API_KEY === 'YOUR_OPENAI_API_KEY_HERE') {
    http_response_code(500);
    echo json_encode(['error' => 'OpenAI API key not configured. Please set OPENAI_API_KEY environment variable or update the code.']);
    exit();
}

// ==================== STEP 1: Get seed artists from OpenAI ====================
$openaiEndpoint = 'https://api.openai.com/v1/chat/completions';

$systemPrompt = "You are a music expert. When asked for a list of artists, return ONLY a valid JSON array of objects. Each object must have 'name' (string) only. Return 3-5 highly relevant seed artists. Example format: [{\"name\":\"Artist Name\"},{\"name\":\"Another Artist\"}]";

$requestBody = [
    'model' => 'gpt-4o-mini',
    'messages' => [
        [
            'role' => 'system',
            'content' => $systemPrompt
        ],
        [
            'role' => 'user',
            'content' => $prompt . "\n\nReturn your response as a JSON array only, with no additional text or explanation."
        ]
    ],
    'temperature' => 0.7,
    'max_tokens' => 500,
    'response_format' => ['type' => 'json_object']
];

$ch = curl_init($openaiEndpoint);
curl_setopt_array($ch, [
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_POST => true,
    CURLOPT_HTTPHEADER => [
        'Content-Type: application/json',
        'Authorization: Bearer ' . $OPENAI_API_KEY
    ],
    CURLOPT_POSTFIELDS => json_encode($requestBody),
    CURLOPT_TIMEOUT => 30
]);

$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
$curlError = curl_error($ch);
curl_close($ch);

if ($curlError) {
    http_response_code(500);
    echo json_encode(['error' => 'Network error: ' . $curlError]);
    exit();
}

if ($httpCode !== 200) {
    $errorData = json_decode($response, true);
    $errorMessage = isset($errorData['error']['message']) ? $errorData['error']['message'] : 'OpenAI API error';
    http_response_code($httpCode);
    echo json_encode(['error' => $errorMessage]);
    exit();
}

$responseData = json_decode($response, true);

if (!isset($responseData['choices'][0]['message']['content'])) {
    http_response_code(500);
    echo json_encode(['error' => 'Invalid response from OpenAI']);
    exit();
}

$content = $responseData['choices'][0]['message']['content'];
$artistsData = json_decode($content, true);

// Handle different response formats
$seedArtists = [];
if (isset($artistsData['artists']) && is_array($artistsData['artists'])) {
    $seedArtists = $artistsData['artists'];
} elseif (is_array($artistsData)) {
    if (isset($artistsData[0]) && is_array($artistsData[0])) {
        $seedArtists = $artistsData;
    } else {
        foreach ($artistsData as $value) {
            if (is_array($value) && isset($value[0])) {
                $seedArtists = $value;
                break;
            }
        }
    }
}

// Clean seed artists and mark them as from OpenAI
$openaiArtists = [];
foreach ($seedArtists as $artist) {
    if (isset($artist['name']) && !empty(trim($artist['name']))) {
        $openaiArtists[] = [
            'name' => trim($artist['name']),
            'source' => 'openai'
        ];
    }
}

if (empty($openaiArtists)) {
    http_response_code(200);
    echo json_encode([
        'source' => 'openai',
        'openai_artists' => [],
        'lastfm_artists' => [],
        'all_artists' => [],
        'message' => 'No artists found in the response'
    ]);
    exit();
}

// ==================== STEP 2: Expand with Last.fm similar artists ====================
$lastfmArtists = [];
$processedNames = [];

// Track OpenAI artists to avoid duplicates
foreach ($openaiArtists as $artist) {
    $normalizedName = normalizeArtistName($artist['name']);
    $processedNames[$normalizedName] = true;
}

// Fetch similar artists for each seed artist
foreach ($openaiArtists as $seedArtist) {
    $artistName = $seedArtist['name'];
    
    // Get similar artists from Last.fm
    $similarArtists = getSimilarArtists($artistName, $LASTFM_API_KEY);
    
    foreach ($similarArtists as $similarArtist) {
        $normalizedName = normalizeArtistName($similarArtist['name']);
        
        // Deduplicate by normalized name
        if (!isset($processedNames[$normalizedName])) {
            // Mark as from Last.fm
            $similarArtist['source'] = 'lastfm';
            $lastfmArtists[] = $similarArtist;
            $processedNames[$normalizedName] = true;
        }
        
        // Stop if we have enough artists total
        if (count($openaiArtists) + count($lastfmArtists) >= 50) {
            break 2;
        }
    }
}

// Combine all artists
$allArtists = array_merge($openaiArtists, $lastfmArtists);

// Return successful response with separated data
http_response_code(200);
echo json_encode([
    'source' => 'openai+lastfm',
    'openai_artists' => $openaiArtists,
    'lastfm_artists' => $lastfmArtists,
    'all_artists' => $allArtists,
    'counts' => [
        'openai' => count($openaiArtists),
        'lastfm' => count($lastfmArtists),
        'total' => count($allArtists)
    ]
]);

// ==================== HELPER FUNCTIONS ====================

function getSimilarArtists($artistName, $apiKey) {
    $url = 'https://ws.audioscrobbler.com/2.0/?method=artist.getsimilar&artist=' 
           . urlencode($artistName) 
           . '&api_key=' . $apiKey 
           . '&format=json&limit=20';
    
    $ch = curl_init($url);
    curl_setopt_array($ch, [
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_TIMEOUT => 10,
        CURLOPT_FOLLOWLOCATION => true
    ]);
    
    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    
    if ($httpCode !== 200 || !$response) {
        return [];
    }
    
    $data = json_decode($response, true);
    
    if (!isset($data['similarartists']['artist']) || !is_array($data['similarartists']['artist'])) {
        return [];
    }
    
    $similarArtists = [];
    foreach ($data['similarartists']['artist'] as $artist) {
        if (isset($artist['name']) && !empty(trim($artist['name']))) {
            $artistData = ['name' => trim($artist['name'])];
            
            if (isset($artist['url'])) {
                $artistData['lastfm_url'] = $artist['url'];
            }
            
            if (isset($artist['mbid']) && !empty($artist['mbid'])) {
                $artistData['mbid'] = $artist['mbid'];
            }
            
            if (isset($artist['match'])) {
                $artistData['match'] = floatval($artist['match']);
            }
            
            $similarArtists[] = $artistData;
        }
    }
    
    return $similarArtists;
}

function normalizeArtistName($name) {
    $normalized = strtolower(trim($name));
    $normalized = str_replace(['the ', '&', ' and '], ['', 'and', ' '], $normalized);
    $normalized = preg_replace('/[^a-z0-9\s]/', '', $normalized);
    $normalized = preg_replace('/\s+/', ' ', $normalized);
    return trim($normalized);
}
?>