<?php
// Database configuration
define('DB_HOST', 'localhost');
define('DB_NAME', 'syncplace_app');
define('DB_USER', 'syncplace_tool');
define('DB_PASS', 'ymbP9{Of}9Kow12N');
define('CACHE_DAYS', 200); // Cache duration in days

// Create database connection
function getDbConnection() {
    static $conn = null;
    
    if ($conn === null) {
        try {
            $conn = new PDO(
                "mysql:host=" . DB_HOST . ";dbname=" . DB_NAME . ";charset=utf8mb4",
                DB_USER,
                DB_PASS,
                [
                    PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
                    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
                    PDO::ATTR_EMULATE_PREPARES => false
                ]
            );
        } catch (PDOException $e) {
            error_log("Database connection failed: " . $e->getMessage());
            return null;
        }
    }
    
    return $conn;
}

// Calculate expiration timestamp
function getCacheExpiration() {
    return date('Y-m-d H:i:s', strtotime('+' . CACHE_DAYS . ' days'));
}

// Update cache stats
function updateCacheStats($endpoint, $isHit) {
    $conn = getDbConnection();
    if (!$conn) return;
    
    try {
        $hitField = $isHit ? 'cache_hits' : 'cache_misses';
        $stmt = $conn->prepare("
            UPDATE cache_stats 
            SET {$hitField} = {$hitField} + 1,
                total_requests = total_requests + 1
            WHERE endpoint = ?
        ");
        $stmt->execute([$endpoint]);
    } catch (PDOException $e) {
        error_log("Failed to update cache stats: " . $e->getMessage());
    }
}

// Clean expired cache entries
function cleanExpiredCache($table) {
    $conn = getDbConnection();
    if (!$conn) return;
    
    try {
        $stmt = $conn->prepare("DELETE FROM {$table} WHERE expires_at < NOW()");
        $stmt->execute();
        return $stmt->rowCount();
    } catch (PDOException $e) {
        error_log("Failed to clean expired cache: " . $e->getMessage());
        return 0;
    }
}

// Normalize supervisor name for consistent lookups
function normalizeSupervisorName($name) {
    $normalized = strtolower(trim($name));
    $normalized = preg_replace('/[^a-z0-9\s]/', '', $normalized);
    $normalized = preg_replace('/\s+/', ' ', $normalized);
    return trim($normalized);
}
?>